<?php

namespace App\Module\Companies\Models\Admin;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Company extends Model 
{

    protected $table = 'companies';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'email', 'phone', 'website', 'kid_code', 'type', 'number_of_employees', 'connectivity', 'contact_person');

    public function users()
    {
        return $this->hasMany('Company');
    }

    public function addresses()
    {
        return $this->hasMany('MainAddress');
    }

    public function submittedData()
    {
        return $this->hasMany('SubmittedData');
    }

    public function invoiceDetails()
    {
        return $this->hasOne('InvoiceDetails');
    }

    public function services()
    {
        return $this->hasMany('Service');
    }

    public function manualParameters()
    {
        return $this->hasMany('ManualParameters');
    }

    public function programs()
    {
        return $this->hasMany('Program');
    }

}